/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.ommc.impl.generic.highlightWaypoint;

import com.mojang.blaze3d.systems.RenderSystem;
import com.plusls.ommc.impl.generic.highlightWaypoint.HighlightWaypointHandler;
import com.plusls.ommc.impl.generic.highlightWaypoint.HighlightWaypointResourceLoader;
import lombok.Generated;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_822;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.compat.minecraft.client.gui.FontCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.resources.ResourceLocationCompat;
import top.hendrixshen.magiclib.api.compat.mojang.blaze3d.vertex.VertexFormatCompat;
import top.hendrixshen.magiclib.api.event.Listener;
import top.hendrixshen.magiclib.api.event.minecraft.render.RenderLevelListener;
import top.hendrixshen.magiclib.api.render.context.RenderContext;
import top.hendrixshen.magiclib.impl.render.context.RenderGlobal;
import top.hendrixshen.magiclib.util.minecraft.PositionUtil;
import top.hendrixshen.magiclib.util.minecraft.render.RenderUtil;

public class HighlightWaypointRenderer
implements RenderLevelListener {
    private static final HighlightWaypointRenderer instance = new HighlightWaypointRenderer();
    private static final class_2960 BEAM_LOCATION = ResourceLocationCompat.withDefaultNamespace((String)"textures/entity/beacon_beam.png");
    public class_1058 targetIdSprite;
    protected long lastBeamTime = 0L;

    public static void init() {
        MagicLib.getInstance().getEventManager().register(RenderLevelListener.class, (Listener)instance);
    }

    public void preRenderLevel(class_1937 level, RenderContext context, float partialTicks) {
    }

    public void postRenderLevel(class_1937 level, RenderContext context, float partialTicks) {
        double distance;
        class_2338 waypointPos = HighlightWaypointHandler.getInstance().getHighlightPos();
        if (waypointPos == null) {
            return;
        }
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 cameraPos = camera.method_19331().method_5836(partialTicks);
        double maxDistance = (Integer)class_310.method_1551().field_1690.method_42503().method_41753() * 16;
        class_243 target = PositionUtil.centerOf((class_2338)waypointPos);
        double renderDistance = distance = target.method_1022(cameraPos);
        if (distance > maxDistance) {
            class_243 direction = target.method_1020(cameraPos);
            target = cameraPos.method_1019(direction.method_1029().method_18805(maxDistance, maxDistance, maxDistance));
            renderDistance = maxDistance;
        }
        class_243 vec3 = target.method_1020(cameraPos);
        context = RenderContext.of((class_4587)new class_4587());
        context.pushMatrix();
        context.translate(vec3.method_10216(), vec3.method_10214(), vec3.method_10215());
        RenderGlobal.disableDepthTest();
        if (this.lastBeamTime >= System.currentTimeMillis()) {
            context.pushMatrix();
            context.translate(-0.5, -0.5, -0.5);
            this.renderBeam(level, context, partialTicks);
            context.popMatrix();
        }
        context.pushMatrix();
        context.mulPoseMatrix(new Matrix4f().rotation((Quaternionfc)camera.method_23767()));
        float scale = (float)((renderDistance > 8.0 ? renderDistance - 8.0 : 0.0) * 0.2 + 1.0) * 0.0265f;
        context.scale((double)((float)RenderUtil.getSizeScalingXSign() * scale), (double)(-scale), (double)(-scale));
        context.pushMatrix();
        context.translate(0.0, 5.0, 0.0);
        this.renderText(context, String.format("x:%d, y:%d, z:%d (%dm)", waypointPos.method_10263(), waypointPos.method_10264(), waypointPos.method_10260(), (int)distance));
        context.popMatrix();
        RenderGlobal.disableDepthTest();
        this.renderIcon(context);
        RenderGlobal.enableDepthTest();
        context.popMatrix();
        context.popMatrix();
    }

    private void renderBeam(@NotNull class_1937 level, @NotNull RenderContext context, float partialTicks) {
        class_4597.class_4598 bufferBuilder = RenderUtil.getBufferSource();
        class_822.method_3545((class_4587)context.getMatrixStack().getPoseStack(), (class_4597)bufferBuilder, (class_2960)BEAM_LOCATION, (float)partialTicks, (float)1.0f, (long)level.method_8510(), (int)-128, (int)256, (int)0xFF0000, (float)0.2f, (float)0.25f);
        bufferBuilder.method_22993();
        RenderGlobal.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderText(@NotNull RenderContext context, String text) {
        FontCompat fontCompat = FontCompat.of((class_327)class_310.method_1551().field_1772);
        int halfTextWidth = ((class_327)fontCompat.get()).method_1727(text) / 2;
        int bgColor = Integer.MIN_VALUE;
        while (true) {
            class_4597.class_4598 immediate = RenderUtil.getBufferSource();
            fontCompat.drawInBatch(text, (float)(-halfTextWidth), 0.0f, 0xFFFFFF, false, context.getMatrixStack().getPoseStack().method_23760().method_23761(), (class_4597)immediate, FontCompat.DisplayMode.SEE_THROUGH, bgColor, 0xF000F0);
            immediate.method_22993();
            if (bgColor == 0) break;
            bgColor = 0;
        }
    }

    private void renderIcon(@NotNull RenderContext context) {
        class_1058 icon = HighlightWaypointResourceLoader.targetIdSprite;
        RenderGlobal.enableBlend();
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_60827(VertexFormatCompat.Mode.QUADS, class_290.field_1575);
        Matrix4f matrix4f = context.getMatrixStack().getPoseStack().method_23760().method_23761();
        float xWidth = 10.0f;
        float yWidth = 10.0f;
        float iconR = 1.0f;
        float iconG = 0.0f;
        float iconB = 0.0f;
        bufferBuilder.method_22918(matrix4f, -xWidth, -yWidth, 0.0f).method_22913(icon.method_4594(), icon.method_4593()).method_22915(iconR, iconG, iconB, 0.5f);
        bufferBuilder.method_22918(matrix4f, -xWidth, yWidth, 0.0f).method_22913(icon.method_4594(), icon.method_4575()).method_22915(iconR, iconG, iconB, 0.5f);
        bufferBuilder.method_22918(matrix4f, xWidth, yWidth, 0.0f).method_22913(icon.method_4577(), icon.method_4575()).method_22915(iconR, iconG, iconB, 0.5f);
        bufferBuilder.method_22918(matrix4f, xWidth, -yWidth, 0.0f).method_22913(icon.method_4577(), icon.method_4593()).method_22915(iconR, iconG, iconB, 0.5f);
        HighlightWaypointRenderer.end(bufferBuilder);
    }

    private static void end(class_287 builder) {
        try (class_9801 meshData = builder.method_60800();){
            class_286.method_43433((class_9801)meshData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Generated
    private HighlightWaypointRenderer() {
    }

    @Generated
    public static HighlightWaypointRenderer getInstance() {
        return instance;
    }
}

